(function(jQuery, window){
  jQuery.extend({
    /**
     * 适配方法
     * cssUrl:["css/test.css",] 需要适配的css路径，参数为数组
     */
    adaptation: function(pms) {
      var ts = this;
      ts.cssConfig = {}; //css配置文件
      if (typeof pms == "undefined") return;
      ts.cssConfig.lastpx = typeof pms.lastpx != "undefined" ? pms.lastpx : 0.5; //禁止1像素转换,默认TRUE
      ts.cssConfig.size = typeof pms.size != "undefined" ? pms.size : 640; //设置初始化适配大小

      ts.cssConfig.cssUrlLen = pms.cssUrl.length;
      ts.cssConfig.cssNowLoadIndex = 0;
      ts.cssConfig.cssLoadArrData = []; //设置css加载数组
      ts.cssConfig.isall = typeof pms.isall != "undefined" ? pms.isall : true; //是否获取全部样式表,开启走全局,不开启走局部
      ts.cssConfig.startcss = typeof pms.startcss != "undefined" ? pms.startcss : "/*startdom*/"; //开始样式
      ts.cssConfig.endcss = typeof pms.endcss != "undefined" ? pms.endcss : "/*enddom*/"; //结束样式

      ts.cssConfig.maxauto = pms.maxauto ? pms.maxauto : false; //往大适配

      ts.metaConfig = {}; //meta配置文件
      ts.metaConfig.metaview = pms.metaview ? pms.metaview : '<meta name="viewport" content="width=device-width, minimum-scale=1.0, maximum-scale=1.0" user-scalable=no />';
      //适配初始化
      ts.adaptationinit();

      //开启响应式方法
      ts.cssConfig.response = pms.response ? pms.response : false; // 开启响应式
      ts.responses(ts.cssConfig.response, pms.responsecbk);
      $(window).resize(function() {
        ts.responses(ts.cssConfig.response, pms.responsecbk);
      });
      for (var i = 0; i < pms.cssUrl.length; i++) {
        //获得css数据
        ts.getCssData({
          cssurl: pms.cssUrl[i], //加载样式引入地址
          cssLoadKey: i, //加载序列
          //回调
          cbk: function(cssData, cssLoadKey) {
            if (typeof ts.cssConfig.cssDatas == "undefined") {
              ts.cssConfig.cssDatas = "";
            }

            //*调用转换css方法
            ts.cssChange({
              cssDatas: cssData,
              cssLoadKey: cssLoadKey, //加载序列
              isall: ts.cssConfig.isall, //是否全局适配
              startCss: ts.cssConfig.startcss,
              endCss: ts.cssConfig.endcss,
              //最后处理回调,这个只在最后一步处理,放心
              cbk: function(cssData) {
                ts.cssGetPx({
                  cssData: cssData,
                  cbk: pms.cbk
                });
                $(window).resize(function(event) {
                  ts.cssGetPx({
                    cssData: cssData,
                    cbk: pms.cbk
                  });
                });

              }
            });

          }
        });

      }

    },
    /**
     * [getCssData 获得css数据,]
     * @param  {[type]} pms [css路径,css回调(返回的数据),支持页面中ID或者CLASS中的css]
     * @return {[type]}     [返回css数据]
     */
    getCssData: function(pms) {
      var ts = this;
      if (ts.isNull(pms) || ts.isNull(pms.cssurl)) {
        return false;
      }
      var urlFirstStr = pms.cssurl.substr(0, 1);
      switch (urlFirstStr) {
        case ".":
          pms.cbk($(pms.cssurl).html(), pms.cssLoadKey);
          break;
        case "#":
          pms.cbk($(pms.cssurl).html(), pms.cssLoadKey);
          break;
        default:

          ts.ajax({
            url: pms.cssurl,
            type: "get",
            //data: { name: "super", age: 20 },
            dataType: "text",
            success: function(data) {
              pms.cbk(data, pms.cssLoadKey);
            },
            error: function(e) {
              throw new Error("getCssData error");
            }
          });
          break;
      }

    },
    /**
     * [cssChange 改变css样式]
     * @param  {[type]} pms [description]
     * @return {[type]}     [description]
     */
    cssChange: function(pms) {
      if (typeof pms == "undefined") return;
      var ts = this;
      var isall = pms.isall; //是否拿全部数据
      var allCss = pms.cssDatas,
        newCss = '';
      if (!isall) {
        var start = pms.startCss;
        var end = pms.endCss;
        var allCss = pms.cssDatas;
        newCss = allCss.substr(allCss.indexOf(start) + start.length);
        newCss = newCss.substring(0, newCss.indexOf(end));
      } else {
        newCss = allCss;
      }
      ts.cssConfig.cssLoadArrData.push([pms.cssLoadKey, newCss]); //插入CSS加载数据
      ts.cssConfig.cssNowLoadIndex++;
      //判断最后一步
      if (ts.cssConfig.cssNowLoadIndex >= ts.cssConfig.cssUrlLen) {
        ts.cssConfig.cssLoadArrData = ts.unique(ts.cssConfig.cssLoadArrData); //获得转换的js
        ts.cssConfig.cssLoadArrData.sort();
        for (var i = 0; i < ts.cssConfig.cssLoadArrData.length; i++) {
          ts.cssConfig.cssDatas += ts.cssConfig.cssLoadArrData[i][1];
        }
        pms.cbk(ts.cssConfig.cssDatas);
      }
    },
    //css转换
    cssGetPx: function(pms) {
      if (typeof pms == "undefined") return;
      if (!pms || $.trim(pms.cssData) == "") return false;
      var ts = this;
      var cssRpData = ts.cssConfig.cssRpData = (typeof ts.cssConfig.cssRpData != "undefined") ? ts.cssConfig.cssRpData : pms.cssData.replace(/([\d\.]+)(?:px)/gi, "|");
      var cssMtData = ts.cssConfig.cssMtData = (typeof ts.cssConfig.cssMtData != "undefined") ? ts.cssConfig.cssMtData : pms.cssData.match(/([\d\.]+)(?:px)/gi);
      var cssArr = ts.cssConfig.cssArr = (typeof ts.cssConfig.cssArr != "undefined") ? ts.cssConfig.cssArr : cssRpData.split("|"); //转换数组
      var newCssData = "";
      for (var i = 0; i < cssMtData.length; i++) {
        var pxnum = ts.getPX(cssMtData[i]);
        if (cssArr[i].indexOf("jpg") > -1 || cssArr[i].indexOf("png") > -1 || cssArr[i].indexOf("gif") > -1 || cssArr[i].indexOf("jpeg") > -1) {
          cssArr[i] = cssArr[i].replace(/\.\.\//g, "./");
        }
        newCssData += cssArr[i] + pxnum + "px";
      }
      newCssData += cssArr[cssArr.length - 1];

      $("#resizestyle").remove();
      var newCssDom = '<style id="resizestyle" type="text/css">' + newCssData + "</style>";
      $("head:eq(0)").append(newCssDom);
      //处理完成后回调
      setTimeout(function() {
        pms.cbk();
      }, 100);
    },
    /**
     * [getPX 获得换算单位]
     * @param  {[type]} px [px单位像素]
     * @return {[type]}    [返回换算的单位值]
     */
    getPX: function(px, size) {
      var ts = this;
      var size = typeof size != "undefined" ? size : ts.cssConfig.size;
      var winW = $(window).width();

      //兼容是否全局适配
      if (!ts.cssConfig.maxauto) {
        if (winW >= ts.cssConfig.size) {
          winW = ts.cssConfig.size;
        }
      }

      var pxnum = parseInt(px);
      var newPx = (pxnum != 0) ? ((pxnum / size) * winW).toFixed(2) : 0;
      if (newPx < ts.cssConfig.lastpx && newPx != 0) {
        return ts.cssConfig.lastpx;
      }
      return newPx;
    },
    //适配初始化
    adaptationinit: function() {
      var ts = this;
      if ($("meta[name=viewport]").length <= 0) {
        $("head").append(ts.metaConfig.metaview);
      }
    },
    /**
     * 开启响应式插件
     * @param pms
     * @param cbk
     * wap <= 640, 640 > pad <= 960 , pc > 960
     * .wap-pad [0~640] .pad-pc [640~无限]
     */
    responses: function(pms, cbk) {
      if (!pms) return;
      var ts = this;
      var winw = ts.win.ww();
      var rdata = {};
      if (winw <= 640) {
        $(".wap,.wap-pad").show();
        $(".pc,.pad,.pad-pc").hide();
        rdata.rname = "wap";
      } else if (640 < winw && winw <= 960) {
        $(".pad,.pad-pc").show();
        $(".pc,.wap,.wap-pad").hide();
        rdata.rname = "pad";
      } else {
        $(".pc,.pad-pc").show();
        $(".wap,.pad,.wap-pad").hide();
        rdata.rname = "pc";
      }
      rdata.rw = winw;

      setTimeout(function() {
        if (cbk) {
          cbk(rdata)
        }
      }, 30);
    },
    /**
     * @author lucky
     * 判断变量是否为空或者undefined或者是null
     * @DateTime 2018-11-14T14:26:28+0800
     * @return   {Boolean}                [description]
     */
    isNull: function(a) {
      var _this = this;
      switch (_this.type(a)) {
        case "string":
          return null == a || undefined == a || "" == a ? true : false;
        case "array":
          return null == a || undefined == a || a == [] || 0 == a.length ? true : false;
        case "number":
          return !1;
        case "object":
          return _this.isEmptyObject(a) ? true : false;
        case "boolean":
          return a;
        case "function":
          return true;
        default:
          return null == a || undefined == a ? true : false;
      }
    },
  })
})(jQuery, window)